function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 241);

T = World_Economy_Cartel_VD.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(111) = exp(y(22))*T(29)*T(92);
T(112) = T(32)+T(31)*y(20)*(-(exp(y(22))*exp(y(43))));
T(113) = (-(exp(y(95))*exp(y(32))*exp(y(87))));
T(114) = (exp(y(24))+exp(y(23)))*(exp(y(24))+exp(y(23)));
T(115) = (exp(y(23))*(exp(y(24))+exp(y(23)))-exp(y(23))*exp(y(23)))/T(114);
T(116) = (-(exp(y(24))*exp(y(23))))/T(114);
T(117) = (exp(y(24))*(exp(y(24))+exp(y(23)))-exp(y(24))*exp(y(24)))/T(114);
T(118) = (exp(y(26))+T(29))*(exp(y(26))+T(29));
T(119) = (T(29)*(exp(y(26))+T(29))-T(29)*T(29))/T(118);
T(120) = (-(exp(y(26))*T(29)))/T(118);
T(121) = (exp(y(26))*(exp(y(26))+T(29))-exp(y(26))*exp(y(26)))/T(118);
T(122) = (-(exp(y(6))*exp((-y(45)))*exp(y(10))));
T(123) = T(41)+params(21)*y(102)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(49);
T(124) = y(72)*T(105)+y(68)*T(106)+y(60)*exp(y(6))*params(6)*(-params(5))*params(5)*exp(params(5)*(y(10)-y(45)));
T(125) = (-(exp(y(6))*(-(exp((-y(45)))*exp(y(10))))));
T(126) = T(39)+T(45)+params(21)*y(102)*exp(y(27))*params(6)*params(5)*params(5)*exp(params(5)*(y(31)-y(97)));
T(127) = T(31)*y(20)*exp(y(43))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T(31)*y(18)*(-(exp(y(43))*(exp(y(22))*exp(y(11))+y(34)*(-exp(y(11)))-params(6)*params(5)*exp(params(5)*y(11)))));
T(128) = (-(exp(y(95))*(exp(y(32))*exp(y(87))+y(88)*(-exp(y(32)))-params(6)*params(5)*params(5)*exp(params(5)*y(32)))));
T(129) = y(63)*T(128);
T(130) = T(31)*y(18)*(-(exp(y(43))*(1-exp(y(11)))))+T(31)*exp(y(43))*y(20);
T(131) = T(8)*getPowerDeriv(T(8),T(13),2);
T(132) = T(8)*T(131);
T(133) = T(50)+T(132);
T(134) = T(8)*getPowerDeriv(T(8),T(1),2);
T(135) = T(8)*T(134);
T(136) = T(51)+T(135);
T(137) = params(11)*T(136);
T(138) = getPowerDeriv(T(9),T(10),2);
T(139) = exp(y(90))*getPowerDeriv(exp(y(90)),T(1),1);
T(140) = getPowerDeriv(T(64),T(10),2);
T(141) = exp(y(37))*getPowerDeriv(exp(y(37)),T(11),2);
T(142) = exp(y(37))*T(141);
T(143) = T(53)+T(142);
T(144) = y(58)*(-(T(19)*T(16)*T(54)*T(82)+T(5)*T(19)*T(54)*T(84)))+y(57)*(-(T(17)*T(3)*T(55)*T(84)+T(3)*T(16)*T(55)*T(86)));
T(145) = (-(T(5)*T(19)*T(16)*T(53)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))));
T(146) = (-(T(17)*T(3)*T(16)*T(53)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(147) = y(58)*T(145)+y(57)*T(146);
T(148) = exp(y(91))*getPowerDeriv(exp(y(91)),T(11),1);
T(149) = (1-params(11))*(1-params(3))*exp(T(1)*y(96))*T(148);
T(150) = (-(T(57)*(T(72)*T(71)*(1-params(11))*params(3)*exp(T(1)*y(96))*T(148)+T(74)*T(69)*(1-params(11))*params(3)*exp(T(1)*y(96))*T(148))));
T(151) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(152) = T(5)*T(151);
T(153) = T(2)*T(88)*T(152);
T(154) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(155) = (-(T(5)*(T(16)*T(54)*T(154)+T(19)*T(54)*T(83)*T(152))));
T(156) = T(16)*T(55)*T(151)+T(3)*T(55)*T(83)*T(152);
T(157) = getPowerDeriv(T(6),T(13),2);
T(158) = T(83)*T(82)*T(151)+T(3)*T(82)*T(152)*T(157);
T(159) = T(15)*T(16)*T(151)+T(3)*T(15)*T(83)*T(152);
T(160) = getPowerDeriv(T(6),T(1),2);
T(161) = T(2)*(T(88)*T(82)*T(151)+T(3)*T(82)*T(152)*T(160));
T(162) = (-(exp(y(39)*(1-params(3)))*T(1)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
T(163) = T(16)*T(97)*T(154)+T(19)*T(97)*T(83)*T(152);
T(164) = T(16)*T(98)*T(151)+T(3)*T(98)*T(83)*T(152);
T(165) = T(20)*getPowerDeriv(T(20),params(3),2);
T(166) = T(20)*T(165);
T(167) = T(58)+T(166);
T(168) = getPowerDeriv(T(60),T(1),2);
T(169) = T(56)*(T(61)*T(57)*T(167)+T(57)*T(58)*T(57)*T(58)*T(168));
T(170) = getPowerDeriv(T(60),T(13),2);
T(171) = T(70)*T(57)*T(167)+T(57)*T(58)*T(57)*T(58)*T(170);
T(172) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(173) = T(20)*T(172);
T(174) = T(74)+T(173);
T(175) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(176) = (-(params(9)*T(175)/(1+params(8))));
T(177) = getPowerDeriv(T(25),(-params(14)),1);
T(178) = T(176)*T(177);
T(179) = (-((-(params(1)*T(79)*T(178)))/(T(26)*T(26))));
T(180) = (-((-(params(1)*T(92)*T(178)))/(T(26)*T(26))));
T(181) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(182) = T(4)*T(181);
T(183) = T(76)+T(182);
T(184) = (-(params(9)*T(183)/(1+params(8))));
T(185) = getPowerDeriv(T(23),(-params(14)),2);
T(186) = T(78)*T(184)+T(77)*T(77)*T(185);
T(187) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(188) = T(4)*T(187);
T(189) = T(82)+T(188);
T(190) = T(83)*T(3)*T(189)+T(3)*T(82)*T(3)*T(82)*T(157);
T(191) = (-(T(82)*T(19)*T(18)*T(84)+T(16)*T(18)*T(19)*T(189)+T(82)*T(19)*T(18)*T(84)+T(5)*T(19)*T(18)*T(190)));
T(192) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(193) = T(4)*T(192);
T(194) = T(86)+T(193);
T(195) = (-(T(3)*T(15)*T(84)*T(86)+T(17)*T(3)*T(15)*T(190)+T(3)*T(15)*T(84)*T(86)+T(3)*T(15)*T(16)*T(194)));
T(196) = T(2)*(T(88)*T(3)*T(189)+T(3)*T(82)*T(3)*T(82)*T(160));
T(197) = T(24)*T(24)*T(24)*T(24);
T(198) = (-((T(24)*T(24)*(-(T(91)*T(186)))-(-(T(79)*T(91)))*(T(24)*T(79)+T(24)*T(79)))/T(197)));
T(199) = exp(y(40))*T(77)*T(185);
T(200) = T(24)*T(24)*(-(T(91)*T(199)))-(-(T(91)*T(92)))*(T(24)*T(79)+T(24)*T(79));
T(201) = (-(T(82)*T(19)*T(16)*T(97)+T(5)*T(19)*T(84)*T(97)));
T(202) = y(58)*T(201);
T(203) = y(57)*(-(T(86)*T(3)*T(16)*T(98)+T(17)*T(3)*T(84)*T(98)));
T(204) = T(3)*T(82)*T(88)*T(99);
T(205) = T(79)*T(103);
T(206) = exp(y(92))*getPowerDeriv(exp(y(92)),1-params(3),1);
T(207) = T(56)*(T(61)*T(58)*T(206)+T(57)*T(58)*T(168)*T(59)*T(206));
T(208) = exp(y(92))*getPowerDeriv(exp(y(92)),(-params(3)),1);
T(209) = T(70)*T(58)*T(206)+T(57)*T(58)*T(170)*T(59)*T(206);
T(210) = exp(y(92))*getPowerDeriv(exp(y(92)),1+params(8),1);
T(211) = (-(params(9)*T(210)/(1+params(8))));
T(212) = getPowerDeriv(T(90),(-params(14)),1);
T(213) = params(1)*T(211)*T(212);
T(214) = (-((-(params(1)*T(79)*exp(y(15))*T(177)))/(T(26)*T(26))));
T(215) = (-((-(params(1)*T(92)*exp(y(15))*T(177)))/(T(26)*T(26))));
T(216) = T(77)*exp(y(40))*T(185);
T(217) = T(24)*T(92)+T(24)*T(92);
T(218) = (-((T(24)*T(24)*(-(T(91)*T(216)))-(-(T(79)*T(91)))*T(217))/T(197)));
T(219) = T(92)+exp(y(40))*exp(y(40))*T(185);
T(220) = exp(y(42))*getPowerDeriv(exp(y(42)),T(22),2);
T(221) = exp(y(42))*T(220);
T(222) = T(95)+T(221);
T(223) = (-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(224) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(225) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(44));
T(226) = T(57)*T(58)*T(61)*(1-params(11))*T(1)*exp(T(1)*y(96));
T(227) = T(67)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(96));
T(228) = T(58)*T(69)*T(227)+T(59)*T(71)*T(227);
T(229) = T(72)*T(71)*T(67)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(96))+T(74)*T(69)*T(67)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(96));
T(230) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,2);
T(231) = (-(T(29)*params(6)*(exp(y(52)-y(45))*T(102)+(-exp(y(52)-y(45)))*(-exp(y(52)-y(45)))*T(230))));
T(232) = y(72)*T(122)+y(68)*T(125)+y(60)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(45)))*(-params(5));
T(233) = (-(T(29)*params(6)*((-exp(y(52)-y(45)))*T(102)+exp(y(52)-y(45))*(-exp(y(52)-y(45)))*T(230))));
T(234) = params(21)*y(102)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(97)))*(-params(5))+params(21)*y(105)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(97))))))))+params(21)*y(109)*(-(exp(y(27))*exp(y(31))*(-exp((-y(97))))));
T(235) = params(21)*y(109)*(-(exp(y(27))*exp(y(31))*(-exp((-y(97))))))+params(21)*y(105)*(-(exp(y(27))*(-(exp(y(31))*(-exp((-y(97))))))))+params(21)*y(102)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(97)))*(-params(5));
T(236) = (-exp(y(52)-y(45)))*T(102)+(-exp(y(52)-y(45)))*exp(y(52)-y(45))*T(230);
T(237) = (-(T(29)*params(6)*T(236)));
T(238) = (-(T(29)*params(6)*(exp(y(52)-y(45))*T(102)+exp(y(52)-y(45))*exp(y(52)-y(45))*T(230))));
T(239) = T(31)*(-(exp(y(43))*exp(y(22))*exp(y(11))));
T(240) = params(21)*(-(exp(y(27))*(-(exp((-y(97)))*exp(y(31))))));
T(241) = params(21)*(-(exp(y(27))*exp((-y(97)))*exp(y(31))));

end
